#include "scripts.h"
#include "engine.h"
#include "jfw.h"
#include <fstream>
struct TimerParams {
	int number;
	float time;
	int repeat;
};
typedef TimerParams *PTimerParams;
void JFW_Spawn_Object_Death::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 spawn_location;
	float facing;
	float f;
	const char *c;
	GameObject *object;
	spawn_location = Commands->Get_Position(obj);
	facing = Commands->Get_Facing(obj);
	c = Get_Parameter("Drop_Object");
	f = Get_Float_Parameter("Drop_Height");
	spawn_location.Z = spawn_location.Z + f;
	object = Commands->Create_Object (c, spawn_location);
	Commands->Set_Facing(object,facing);
}
void JFW_Attatch_Script::Entered(GameObject * obj,GameObject * enter)
{
	const char *script;
	const char *param;
	char *params;
	char delim;
	int pltype;
	int destroy;
	int trigger;
	trigger = Get_Int_Parameter("Trigger");
	if (trigger != 1)
	{
		return;
	}
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	script = Get_Parameter("Script_Name");
	param = Get_Parameter("Script_Params");
	params = _strdup(param);
	delim = Get_Parameter("Delim")[0];
	for (unsigned int i=0;i<strlen(params);i++)
	{
		if (params[i] == delim)
		{
			params[i] = ',';
		}
	}
	Commands->Attach_Script(enter,script,params);
	destroy = Get_Int_Parameter("Destroy");
	if (destroy == 1)
	{
		Commands->Destroy_Object(obj);
	}
}
void JFW_Attatch_Script::Killed(GameObject * obj,GameObject * shooter)
{
	const char *script;
	const char *param;
	char *params;
	char delim;
	int destroy;
	int trigger;
	trigger = Get_Int_Parameter("Trigger");
	if (trigger != 2)
	{
		return;
	}
	script = Get_Parameter("Script_Name");
	param = Get_Parameter("Script_Params");
	params = _strdup(param);
	delim = Get_Parameter("Delim")[0];
	for (unsigned int i=0;i<strlen(params);i++)
	{
		if (params[i] == delim)
		{
			params[i] = ',';
		}
	}
	Commands->Attach_Script(shooter,script,params);
	destroy = Get_Int_Parameter("Destroy");
	if (destroy == 1)
	{
		Commands->Destroy_Object(obj);
	}
}
void JFW_Attatch_Script::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *script;
	const char *paramx;
	char *params;
	char delim;
	int msg;
	int destroy;
	int trigger;
	trigger = Get_Int_Parameter("Trigger");
	if (trigger != 3)
	{
		return;
	}
	msg = Get_Int_Parameter("Custom");
	if (message != msg)
	{
		return;
	}
	script = Get_Parameter("Script_Name");
	paramx = Get_Parameter("Script_Params");
	params = _strdup(paramx);
	delim = Get_Parameter("Delim")[0];
	for (unsigned int i=0;i<strlen(params);i++)
	{
		if (params[i] == delim)
		{
			params[i] = ',';
		}
	}
	Commands->Attach_Script(sender,script,params);
	destroy = Get_Int_Parameter("Destroy");
	if (destroy == 1)
	{
		Commands->Destroy_Object(obj);
	}
}
void JFW_Attatch_Script::Poked(GameObject * obj,GameObject * poker)
{
	const char *script;
	const char *param;
	char *params;
	char delim;
	int trigger;
	trigger = Get_Int_Parameter("Trigger");
	if (trigger != 4)
	{
		return;
	}
	int pltype;
	int destroy;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,pltype) != 0)
	{
		return;
	}
	script = Get_Parameter("Script_Name");
	param = Get_Parameter("Script_Params");
	params = _strdup(param);
	delim = Get_Parameter("Delim")[0];
	for (unsigned int i=0;i<strlen(params);i++)
	{
		if (params[i] == delim)
		{
			params[i] = ',';
		}
	}
	Commands->Attach_Script(poker,script,params);
	destroy = Get_Int_Parameter("Destroy");
	if (destroy == 1)
	{
		Commands->Destroy_Object(obj);
	}
}
void JFW_Poke_Send_Custom::Created(GameObject * obj)
{
	int message;
	active = 0;
	message = Get_Int_Parameter("Activate_Message");
	if (message == 0)
	{
		active = 1;
	}
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}

void JFW_Poke_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Activate_Message");
	if (msg == message)
	{
		active = param;
		if ((param == 0) || (param == 1))
		{
			Commands->Enable_HUD_Pokable_Indicator(obj,1);
		}
		else
		{
			Commands->Enable_HUD_Pokable_Indicator(obj,0);
		}
	}
}
void JFW_Poke_Send_Custom::Poked(GameObject * obj,GameObject * poker)
{
	const char *c;
	int msg;
	int param;
	int id;
	float delay;
	Vector3 v;
	GameObject * sendobj;	
	if (active == 0)
	{
		c = Get_Parameter("Sound_Name");
		v = Commands->Get_Position(obj);
		Commands->Create_Sound(c,v,obj);
	}
	else
	{
		if (active == 1)
		{
		active = 2;
		id = Get_Int_Parameter("Object_Id");
		msg = Get_Int_Parameter("Message");
		param = Get_Int_Parameter("Param");
		delay = Get_Float_Parameter("Delay");
		Commands->Enable_HUD_Pokable_Indicator(obj,0);
		sendobj = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj,sendobj,msg,param,delay);
		}
	}
}
void JFW_Poke_Send_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}
void JFW_Custom_Toggle_Radar::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Message");
	if (msg == message)
	{
		Commands->Enable_Radar(param);
	}
}
void JFW_Reflect_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Commands->Send_Custom_Event(obj,sender,message,param,0);
}

void JFW_Custom_Destroy_Object::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int id;
	GameObject * object;
	msg = Get_Int_Parameter("Message");	
	id = Get_Int_Parameter("ID");
	if (msg == message)
	{
		object = Commands->Find_Object(id);
		Commands->Destroy_Object(object);
	}
}
void JFW_Start_Timer::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	x = Get_Int_Parameter("Type");
	if (x != 1)
	{
		return;
	}
	x = Get_Int_Parameter("TypeVal");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	TimerParams z;
	int TimerObject;
	int TimerMessage;
	TimerObject = Get_Int_Parameter("Timer_Object");
	z.number = Get_Int_Parameter("Timer_Number");
	z.time = Get_Float_Parameter("Timer_Time");
	z.repeat = Get_Int_Parameter("Repeat");
	TimerMessage = Get_Int_Parameter("Timer_Custom");
	GameObject * TimerObj = Commands->Find_Object(TimerObject);
	Commands->Send_Custom_Event(obj,TimerObj,TimerMessage,0,0);
}
void JFW_Start_Timer::Poked(GameObject * obj,GameObject * poker)
{
	int x;
	x = Get_Int_Parameter("Type");
	if (x != 4)
	{
		return;
	}
	TimerParams z;
	int TimerObject;
	int TimerMessage;
	TimerObject = Get_Int_Parameter("Timer_Object");
	z.number = Get_Int_Parameter("Timer_Number");
	z.time = Get_Float_Parameter("Timer_Time");
	z.repeat = Get_Int_Parameter("Repeat");
	TimerMessage = Get_Int_Parameter("Timer_Custom");
	GameObject * TimerObj = Commands->Find_Object(TimerObject);
	Commands->Send_Custom_Event(obj,TimerObj,TimerMessage,0,0);
}
void JFW_Start_Timer::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int x;
	x = Get_Int_Parameter("Type");
	if (x != 3)
	{
		return;
	}
	x = Get_Int_Parameter("TypeVal");
	if (x != message)
	{
		return;
	}
	TimerParams z;
	int TimerObject;
	int TimerMessage;
	TimerObject = Get_Int_Parameter("Timer_Object");
	z.number = Get_Int_Parameter("Timer_Number");
	z.time = Get_Float_Parameter("Timer_Time");
	z.repeat = Get_Int_Parameter("Repeat");
	TimerMessage = Get_Int_Parameter("Timer_Custom");
	GameObject * TimerObj = Commands->Find_Object(TimerObject);
	Commands->Send_Custom_Event(obj,TimerObj,TimerMessage,0,0);
}
void JFW_Start_Timer::Killed(GameObject * obj,GameObject * shooter)
{
	int x;
	x = Get_Int_Parameter("Type");
	if (x != 2)
	{
		return;
	}
	TimerParams z;
	int TimerObject;
	int TimerMessage;
	TimerObject = Get_Int_Parameter("Timer_Object");
	z.number = Get_Int_Parameter("Timer_Number");
	z.time = Get_Float_Parameter("Timer_Time");
	z.repeat = Get_Int_Parameter("Repeat");
	TimerMessage = Get_Int_Parameter("Timer_Custom");
	GameObject * TimerObj = Commands->Find_Object(TimerObject);
	Commands->Send_Custom_Event(obj,TimerObj,TimerMessage,0,0);
}
void JFW_Start_Timer::Created(GameObject * obj)
{
	int x;
	x = Get_Int_Parameter("Type");
	if (x != 0)
	{
		return;
	}
	TimerParams z;
	int TimerObject;
	int TimerMessage;
	TimerObject = Get_Int_Parameter("Timer_Object");
	z.number = Get_Int_Parameter("Timer_Number");
	z.time = Get_Float_Parameter("Timer_Time");
	z.repeat = Get_Int_Parameter("Repeat");
	TimerMessage = Get_Int_Parameter("Timer_Custom");
	GameObject * TimerObj = Commands->Find_Object(TimerObject);
	Commands->Send_Custom_Event(obj,TimerObj,TimerMessage,0,0);
}
void JFW_Preset_Buy::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	int cost;
	Vector3 spawn_position;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		spawn_position = Get_Vector3_Parameter("location");
		Commands->Give_Money(enter,(float)cost,0);
		Commands->Create_Object(preset, spawn_position);
	}
}
void JFW_Death_Send_Custom::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("Message");
	param = Get_Int_Parameter("Param");
	object = Commands->Find_Object(ID);
	Commands->Send_Custom_Event(obj,object,message,param,0);
}
void JFW_Death_Play_Cinematic::Killed(GameObject * obj,GameObject * shooter)
{
	const char *scriptname;
	Vector3 position;
	float facing;
	GameObject * object;
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}
void JFW_Zone_Play_Cinematic::Entered(GameObject * obj,GameObject * enter)
{
	const char *scriptname;
	int x;
	Vector3 position;
	float facing;
	GameObject * object;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}
void JFW_Pokeable_Item::Created(GameObject * obj)
{
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void JFW_Blow_Up_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	const char *c;
	Vector3 v;
	c = Get_Parameter("Explosion");
	v = Commands->Get_Position(enter);
	Commands->Create_Explosion(c,v,0);
}
void JFW_Apply_Damage_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	float f;
	const char *w;
	w = Get_Parameter("Warhead");
	f = Get_Float_Parameter("Damage");
	Commands->Apply_Damage(enter,f,w,0);
}
void JFW_Team_DM_Zone::Exited(GameObject * obj,GameObject * exit)
{
	int x;
	int msg;
	const char *c;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x) != 0)
	{
		return;
	}
	msg = Get_Int_Parameter("Deactivate_Message");
	triggered = false;
	Commands->Send_Custom_Event(obj,exit,msg,1,0);
	if (triggered == false)
	{
		char *param;
		const char *params;
		param = "";
		*param = 0;
		c = Get_Parameter("Controller_ID");
		param = strcat(param,c);
		param = strcat(param,",");
		c = Get_Parameter("Deactivate_Message");
		param = strcat(param,c);
		param = strcat(param,",");
		c = Get_Parameter("Death_Message");
		param = strcat(param,c);
		params = _strdup(param);
		Commands->Attach_Script(exit,"JFW_Team_DM_Attatched",params);
	}
}
void JFW_Team_DM_Zone::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Deactivate_Message");
	if (message == msg)
	{
		triggered = true;
	}
}
void JFW_Team_DM_Controller::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int maxdeaths;
	int id;
	GameObject * tmpObj;
	float maxHealth;
	msg = Get_Int_Parameter("Death_Message");
	maxdeaths = Get_Int_Parameter("Deaths_To_Loose");
	if (message == msg)
	{
		deaths++;
	}
	if (deaths >= maxdeaths)
	{
		id = Get_Int_Parameter("Building_To_Destroy1");		
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy2");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy3");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy4");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy5");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
	}
}
void JFW_Team_DM_Attatched::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Deactivate_Message");
	if (message == msg)
	{
		Commands->Send_Custom_Event(obj,sender,msg,1,0);
	}
}
void JFW_Team_DM_Controller::Created(GameObject * obj)
{
	deaths = 0;
}
void JFW_Team_DM_Attatched::Killed(GameObject * obj,GameObject * shooter)
{
	int msg;
	int controller_id;
	GameObject * controller;
	msg = Get_Int_Parameter("Death_Message");
	controller_id = Get_Int_Parameter("Controller_ID");
	controller = Commands->Find_Object(controller_id);
	Commands->Send_Custom_Event(obj,controller,msg,1,0);
}
void JFW_Team_DM_Controller::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&deaths);
}
void JFW_Team_DM_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&triggered);
}
void JFW_Timer_Destroy_Building::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Timer_Destroy_Building::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	timernumber = Get_Int_Parameter("TimerNum");
	if (number == timernumber)
	{
		Commands->Apply_Damage(obj,10000,"Explosive",0);
	}
}
void JFW_Custom_Destroy_Building::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int id;
	GameObject * object;
	msg = Get_Int_Parameter("Message");
	id = Get_Int_Parameter("ID");
	if (msg == message)
	{
		object = Commands->Find_Object(id);
		Commands->Apply_Damage(object,10000,"Explosive",0);
	}
}
void JFW_Zone_PCT::Entered(GameObject * obj,GameObject * enter)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,team) != 0)
	{
		return;
	}
	if (team == 0)
	{
		Display_NOD_Player_Terminal_Player(enter);
	}
	if (team == 1)
	{
		Display_GDI_Player_Terminal_Player(enter);
	}
	if (team == 2)
	{
		if (Commands->Get_Player_Type(enter) == 0)
		{
			Display_NOD_Player_Terminal_Player(enter);
		}
		if (Commands->Get_Player_Type(enter) == 1)
		{
			Display_GDI_Player_Terminal_Player(enter);
		}
	}
}
void JFW_3D_Sound_Zone::Entered(GameObject * obj,GameObject * enter)
{
	int team;
	const char *c;
	Vector3 v;
	team = Get_Int_Parameter("Player_Type");
	c = Get_Parameter("Sound");
	if (CheckPlayerType(enter,team) != 0)
	{
		return;
	}
	v = Commands->Get_Position(enter);
	Commands->Create_Sound(c,v,obj);
}
void JFW_2D_Sound_Timer::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_2D_Sound_Timer::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	float timertime;
	int repeat;
	const char *c;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_2D_Sound(c);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Timer_Play_Cinematic::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Timer_Play_Cinematic::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_User_Settable_Parameters::Created(GameObject * obj)
{
	const char *filename;
	const char *scriptname;
	char params[100];
	const char *param;
	filename = Get_Parameter("File_Name");
	scriptname = Get_Parameter("Script_Name");
	std::ifstream f(filename);
	f.getline(params,100);
	param = _strdup(params);
	Commands->Attach_Script(obj,scriptname,param);
}
void JFW_Nod_Turret::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Nod_Turret::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 position;
	float facing;
	GameObject * object;
	position = Commands->Get_Position(obj);
	facing = Commands->Get_Facing(obj);
	object = Commands->Create_Object("Nod_Turret_Destroyed",position);
	Commands->Set_Facing(object,facing);
}
void JFW_Nod_Turret::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	Vector3 v = Commands->Get_Position(seen);
	ActionParamsStruct params;
	params.Set_Basic(this,100,2,-1);
	v.Z += 0.5;
	params.Set_Attack_Position(v,300.0,0.0,true);
	Commands->Action_Attack(obj, params);
	Commands->Start_Timer(obj, this, 2, 2);
}
void JFW_Nod_Turret::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Nod_Turret::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
		Commands->Start_Timer(obj, this, 10, 1);
		break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Nod_Turret::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
}
void JFW_User_Controllable_Base_Defence::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	player = false;
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_User_Controllable_Base_Defence::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	ActionParamsStruct params;
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		player = false;
		Commands->Set_Player_Type(obj,objtype);
		Commands->Action_Reset(obj,100);
	}
	else
	{
		if (message == CUSTOM_EVENT_VEHICLE_ENTER)
		{
			player = true;
			params.Set_Basic(this,100,3,-1);
			Commands->Action_Follow_Input(obj,params);
		}
	}
}
void JFW_User_Controllable_Base_Defence::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	ActionParamsStruct params;
	Vector3 pos,pos2;
	float distance;
	float minattack,maxattack;
	float attacktimer;
	if (player == false)
	{
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void JFW_User_Controllable_Base_Defence::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_User_Controllable_Base_Defence::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		if (player == false)
		{
			switch (__min(int(f), 2))
			{
			case 0:
				object = Commands->Find_Object(id1);
				if (object)
				{
					var.Set_Basic(this, 70, 1, -1);
					var.Set_Attack(object, 0.0, 0.0, true);
					Commands->Action_Attack(obj, var);
				}
				break;
			case 1:
				object = Commands->Find_Object(id2);
				if (object)
				{
					var.Set_Basic(this, 70, 1, -1);
					var.Set_Attack(object, 0.0, 0.0, true);
					Commands->Action_Attack(obj, var);
				}
				break;
			default:
				object = Commands->Find_Object(id3);
				if (object)
				{
					var.Set_Basic(this, 70, 1, -1);
					var.Set_Attack(object, 0.0, 0.0, true);
					Commands->Action_Attack(obj, var);
				}
			}
		}
		Commands->Start_Timer(obj, this, 10, 1);
		break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_User_Controllable_Base_Defence::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&player);
}
void JFW_Base_Defence::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	ActionParamsStruct params;
	Vector3 pos,pos2;
	float distance;
	float minattack,maxattack;
	float attacktimer;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	distance = Commands->Get_Distance(pos2,pos);
	minattack = Get_Float_Parameter("MinAttackDistance");
	if (distance >= minattack)
	{
		maxattack = Get_Float_Parameter("MaxAttackDistance");
		params.Set_Basic(this,100,2,-1);
		params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
		Commands->Action_Attack(obj,params);
		attacktimer = Get_Float_Parameter("AttackTimer");
		Commands->Start_Timer(obj,this,attacktimer,2);
	}
}
void JFW_Base_Defence::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}
void JFW_Base_Defence_No_Aircraft::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void JFW_Base_Defence_No_Aircraft::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}
void JFW_Base_Defence_Aircraft_Only::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void JFW_Base_Defence_Aircraft_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}
void JFW_Base_Defence_Secondary::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	primary = true;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	ActionParamsStruct params;
	Vector3 pos,pos2;
	float distance;
	float minattack,maxattack;
	float attacktimer;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	distance = Commands->Get_Distance(pos2,pos);
	minattack = Get_Float_Parameter("MinAttackDistance");
	if (distance >= minattack)
	{
		maxattack = Get_Float_Parameter("MaxAttackDistance");
		params.Set_Basic(this,100,2,-1);
		params.Set_Attack_Hold(seen,maxattack,0.0,primary,false);
		Commands->Action_Attack(obj,params);
		attacktimer = Get_Float_Parameter("AttackTimer");
		Commands->Start_Timer(obj,this,attacktimer,2);
		if (primary == true)
		{
			primary = false;
		}
		else
		{
			primary = true;
		}
	}
}
void JFW_Base_Defence_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_Secondary::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&primary);
}
void JFW_Base_Defence_No_Aircraft_Secondary::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	primary = true;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,primary,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_No_Aircraft_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&primary);
}
void JFW_Base_Defence_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	primary = true;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,primary,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Aircraft_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&primary);
}
void JFW_Base_Defence_Animated::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (popup == false)
	{
		popup = true;
		Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
	}
	else if (attack == true)
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
		Commands->Action_Attack(obj,params);
	}
}
void JFW_Base_Defence_Animated::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_No_Aircraft::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_No_Aircraft::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Aircraft_Only::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_Aircraft_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (popup == false)
	{
		popup = true;
		Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
	}
	else if (attack == true)
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
		Commands->Action_Attack(obj,params);
		if (primary == true)
		{
			primary = false;
		}
		else
		{
			primary = true;
		}
	}
}
void JFW_Base_Defence_Animated_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_No_Aircraft_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_No_Aircraft_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{	
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_Aircraft_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
ScriptRegistrant<JFW_Poke_Send_Custom> JFW_Poke_Send_Custom_Registrant("JFW_Poke_Send_Custom","Sound_Name:string,Activate_Message:int,Object_Id:int,Message:int,Param:int,Delay:float");
ScriptRegistrant<JFW_Custom_Toggle_Radar> JFW_Custom_Toggle_Radar_Registrant("JFW_Custom_Toggle_Radar","Message:int");
ScriptRegistrant<JFW_Custom_Destroy_Object> JFW_Custom_Destroy_Object_Registrant("JFW_Custom_Destroy_Object","Message:int,ID:int");
ScriptRegistrant<JFW_Attatch_Script> JFW_Attatch_Script_Registrant("JFW_Attatch_Script","Trigger:int,Player_Type:int,Script_Name:string,Script_Params:string,Delim:string,Destroy:int,Custom:int");
ScriptRegistrant<JFW_Spawn_Object_Death> JFW_Spawn_Object_Death_Registrant("JFW_Spawn_Object_Death","Drop_Object:string,Drop_Height:float");
ScriptRegistrant<JFW_Reflect_Custom> JFW_Reflect_Custom_Registrant("JFW_Reflect_Custom","");
ScriptRegistrant<JFW_Start_Timer> JFW_Start_Timer_Registrant("JFW_Start_Timer","Type:int,TypeVal:int,Timer_Object:int,Timer_Number:int,Timer_Time:float,Repeat:int,Timer_Custom:int");
ScriptRegistrant<JFW_Preset_Buy> JFW_Preset_Buy_Registrant("JFW_Preset_Buy","Preset_Name:string,Cost:int,location:Vector3,Player_Type:int");
ScriptRegistrant<JFW_Death_Send_Custom> JFW_Death_Send_Custom_Registrant("JFW_Death_Send_Custom","ID:int,Message:int,Param:Int");
ScriptRegistrant<JFW_Pokeable_Item> JFW_Pokeable_Item_Registrant("JFW_Pokeable_Item","");
ScriptRegistrant<JFW_Zone_Play_Cinematic> JFW_Zone_Play_Cinematic_Registrant("JFW_Zone_Play_Cinematic","Script_Name:string,location:Vector3,Player_Type:int,Facing:float");
ScriptRegistrant<JFW_Death_Play_Cinematic> JFW_Death_Play_Cinematic_Registrant("JFW_Death_Play_Cinematic","Script_Name:string,location:Vector3,Facing:float");
ScriptRegistrant<JFW_Blow_Up_On_Enter> JFW_Blow_Up_On_Enter_Registrant("JFW_Blow_Up_On_Enter","Explosion:string");
ScriptRegistrant<JFW_Apply_Damage_On_Enter> JFW_Apply_Damage_On_Enter_Registrant("JFW_Apply_Damage_On_Enter","Warhead:string,Damage:float");
ScriptRegistrant<JFW_Team_DM_Controller> JFW_Team_DM_Controller_Registrant("JFW_Team_DM_Controller","Deaths_To_Loose:int,Death_Message:int,Building_To_Destroy1:int,Building_To_Destroy2:int,Building_To_Destroy3:int,Building_To_Destroy4:int,Building_To_Destroy5:int");
ScriptRegistrant<JFW_Team_DM_Zone> JFW_Team_DM_Zone_Registrant("JFW_Team_DM_Zone","Player_Type:int,Controller_ID:int,Deactivate_Message:int,Death_Message:int");
ScriptRegistrant<JFW_Team_DM_Attatched> JFW_Team_DM_Attatched_Registrant("JFW_Team_DM_Attatched","Controller_ID:int,Deactivate_Message:int,Death_Message:int");
ScriptRegistrant<JFW_Timer_Destroy_Building> JFW_Timer_Destroy_Building_Registrant("JFW_Timer_Destroy_Building","Time:float,TimerNum:int");
ScriptRegistrant<JFW_Custom_Destroy_Building> JFW_Custom_Destroy_Building_Registrant("JFW_Custom_Destroy_Building","Message:int,ID:int");
ScriptRegistrant<JFW_Zone_PCT> JFW_Zone_PCT_Registrant("JFW_Zone_PCT","Player_Type:int");
ScriptRegistrant<JFW_2D_Sound_Timer> JFW_2D_Sound_Timer_Registrant("JFW_2D_Sound_Timer","Time:float,TimerNum:int,Repeat:int,Sound:string");
ScriptRegistrant<JFW_3D_Sound_Zone> JFW_3D_Sound_Zone_Registrant("JFW_3D_Sound_Zone","Player_Type:int,Sound:string");
ScriptRegistrant<JFW_Timer_Play_Cinematic> JFW_Timer_Play_Cinematic_Registrant("JFW_Timer_Play_Cinematic","Time:float,TimerNum:int,Repeat:int,Script_Name:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_User_Settable_Parameters> JFW_User_Settable_Parameters_Registrant("JFW_User_Settable_Parameters","File_Name:string,Script_Name:string");
ScriptRegistrant<JFW_Nod_Turret> JFW_Nod_Turret_Registrant("JFW_Nod_Turret","");
ScriptRegistrant<JFW_User_Controllable_Base_Defence> JFW_User_Controllable_Base_Defence_Registrant("JFW_User_Controllable_Base_Defence","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence> JFW_Base_Defence_Registrant("JFW_Base_Defence","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_No_Aircraft> JFW_Base_Defence_No_Aircraft_Registrant("JFW_Base_Defence_No_Aircraft","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Base_Defence_Aircraft_Only> JFW_Base_Defence_Aircraft_Only_Registrant("JFW_Base_Defence_Aircraft_Only","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Base_Defence_Secondary> JFW_Base_Defence_Secondary_Registrant("JFW_Base_Defence_Secondary","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_No_Aircraft_Secondary> JFW_Base_Defence_No_Aircraft_Secondary_Registrant("JFW_Base_Defence_No_Aircraft_Secondary","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Base_Defence_Aircraft_Only_Secondary> JFW_Base_Defence_Aircraft_Only_Secondary_Registrant("JFW_Base_Defence_Aircraft_Only_Secondary","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string");
ScriptRegistrant<JFW_Base_Defence_Animated> JFW_Base_Defence_Animated_Registrant("JFW_Base_Defence_Animated","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_No_Aircraft> JFW_Base_Defence_Animated_No_Aircraft_Registrant("JFW_Base_Defence_Animated_No_Aircraft","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_Aircraft_Only> JFW_Base_Defence_Animated_Aircraft_Only_Registrant("JFW_Base_Defence_Animated_Aircraft_Only","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_Secondary> JFW_Base_Defence_Animated_Secondary_Registrant("JFW_Base_Defence_Animated_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_No_Aircraft_Secondary> JFW_Base_Defence_Animated_No_Aircraft_Secondary_Registrant("JFW_Base_Defence_Animated_No_Aircraft_Secondary","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_Aircraft_Only_Secondary> JFW_Base_Defence_Animated_Aircraft_Only_Secondary_Registrant("JFW_Base_Defence_Animated_Aircraft_Only_Secondary","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float");
